/*
 * Decompiled with CFR 0.152.
 */
package cs251.project2;

import cs251.project2.OthelloInterface;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class OthelloGUI {
    private static final int SQUARE_SIZE = 75;
    private static char DARK = OthelloInterface.Piece.DARK.toChar();
    private static char LIGHT = OthelloInterface.Piece.LIGHT.toChar();
    private static char EMPTY = OthelloInterface.Piece.EMPTY.toChar();
    private static Color BACKGROUND_COLOR = new Color(0, 100, 0);
    private static Color LINE_COLOR = Color.GRAY;
    private static Color DARK_COLOR = Color.BLACK;
    private static Color LIGHT_COLOR = Color.WHITE;
    private Point mouseLocation = null;
    private final OthelloInterface model;
    private final JFrame boardFrame;
    private final JLabel turnLabel = new JLabel();

    private void doMouseMove(Point point) {
        if (this.mouseLocation == null || !point.equals(this.mouseLocation)) {
            this.mouseLocation = point;
            this.boardFrame.repaint();
        }
    }

    private void doMouseClick(int n, int n2) {
        int n3 = n2 / 75;
        int n4 = n / 75;
        boolean bl = true;
        OthelloInterface.Result result = this.model.handleClickAt(n3, n4);
        this.boardFrame.repaint();
        this.updateTurnLabel();
        switch (result) {
            case DRAW: {
                JOptionPane.showMessageDialog(null, "Draw Game!", "Game Over", 1);
                break;
            }
            case LIGHT_WINS: {
                JOptionPane.showMessageDialog(null, "Light Wins!", "Game Over", 1);
                break;
            }
            case DARK_WINS: {
                JOptionPane.showMessageDialog(null, "DARK Wins!", "Game Over", 1);
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            int n5 = JOptionPane.showConfirmDialog(null, "Play again?", "Play again?", 0);
            if (n5 == 1) {
                System.exit(0);
            } else {
                this.model.initGame();
                this.updateTurnLabel();
            }
        }
        this.boardFrame.repaint();
    }

    private void updateTurnLabel() {
        this.turnLabel.setText("<html><h2>Current Player is " + String.valueOf((Object)this.model.getCurrentPlayer()) + "</h2>");
    }

    private OthelloGUI(OthelloInterface othelloInterface) {
        this.model = othelloInterface;
        this.model.initGame();
        this.boardFrame = new JFrame();
        this.boardFrame.setTitle("Othello");
        BoardPanel boardPanel = new BoardPanel();
        boardPanel.setBackground(BACKGROUND_COLOR);
        boardPanel.setPreferredSize(new Dimension(this.model.getSize() * 75 + 1, this.model.getSize() * 75 + 1));
        boardPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                OthelloGUI.this.doMouseClick(n, n2);
            }
        });
        boardPanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                OthelloGUI.this.doMouseMove(mouseEvent.getPoint());
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                OthelloGUI.this.doMouseMove(mouseEvent.getPoint());
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = new JButton("<html><h2>New Game</h2>");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OthelloGUI.this.model.initGame();
                OthelloGUI.this.updateTurnLabel();
                OthelloGUI.this.boardFrame.repaint();
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("<html><h2>Quit</h2>");
        jButton2.addActionListener(new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jPanel.add(jButton2);
        this.boardFrame.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(boardPanel);
        this.boardFrame.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        this.updateTurnLabel();
        jPanel3.add(this.turnLabel);
        this.boardFrame.add((Component)jPanel3, "South");
        this.boardFrame.setResizable(false);
        this.boardFrame.pack();
        this.boardFrame.setDefaultCloseOperation(3);
        this.boardFrame.setLocationRelativeTo(null);
        this.boardFrame.setVisible(true);
    }

    public static void showGUI(final OthelloInterface othelloInterface) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OthelloGUI(othelloInterface);
            }
        });
    }

    private class BoardPanel
    extends JPanel {
        private BoardPanel() {
        }

        public void drawPieces(Graphics graphics) {
            int n;
            int n2;
            String string = OthelloGUI.this.model.getBoardString();
            if (string == null) {
                string = "";
            }
            String[] stringArray = string.split("\\n");
            int n3 = stringArray.length;
            int n4 = 12;
            int n5 = 75 - 2 * n4;
            for (n2 = 0; n2 < n3; ++n2) {
                n = stringArray[n2].length();
                for (int i = 0; i < n; ++i) {
                    char c = stringArray[n2].charAt(i);
                    if (c == DARK) {
                        graphics.setColor(DARK_COLOR);
                        graphics.fillOval(i * 75 + n4, n2 * 75 + n4, n5, n5);
                        continue;
                    }
                    if (c == LIGHT) {
                        graphics.setColor(LIGHT_COLOR);
                        graphics.fillOval(i * 75 + n4, n2 * 75 + n4, n5, n5);
                        continue;
                    }
                    if (c == EMPTY) continue;
                    System.err.println("Unexpected character " + c + " in board string at row " + n2 + ", col " + i);
                }
            }
            if (OthelloGUI.this.mouseLocation != null && OthelloGUI.this.model.isLegal(n2 = OthelloGUI.this.mouseLocation.y / 75, n = OthelloGUI.this.mouseLocation.x / 75)) {
                graphics.setColor(Color.YELLOW);
                graphics.drawOval(n * 75 + n4, n2 * 75 + n4, n5, n5);
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(LINE_COLOR);
            ((Graphics2D)graphics).setStroke(new BasicStroke(3.0f));
            int n = this.getWidth();
            int n2 = this.getHeight();
            for (int i = 0; i <= OthelloGUI.this.model.getSize(); ++i) {
                int n3 = i * 75;
                graphics.drawLine(0, n3, n, n3);
                graphics.drawLine(n3, 0, n3, n2);
            }
            this.drawPieces(graphics);
        }
    }
}

